<?php
// Se incluye el archivo que contiene la clase generica
include_once '../conexion.php';

try {
    // Obtener el RUC de la empresa desde el formulario
    $ruc = $_POST['ruc'];

    // Establecer la conexión a la base de datos utilizando la clase genérica
    // $conexion = new Conexion();
    // $conn = $conexion->getConexion();

    // Preparar la consulta SQL
    $consulta = "SELECT nserie, ndocumento, fecha_emision, fecha_vencimiento, moneda, tipo_cambio, afecto_igv, porcentaje_igv, igv, afecto, inafecto, exonerado, total FROM ventas WHERE documento_identidad = :ruc";

    // Preparar la sentencia
    $stmt = $conn->prepare($consulta);

    // Bind de parámetros
    $stmt->bindParam(':ruc', $ruc, PDO::PARAM_STR);

    // Ejecutar la consulta
    $stmt->execute();

    // Obtener los resultados de la consulta
    $documentos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Verificar si se encontraron documentos
    if (count($documentos) > 0) {
        // Mostrar los documentos en una tabla
        echo '<table>';
        echo '<tr><th>Número de Serie</th><th>Número de Documento</th><th>Fecha de Emisión</th><th>Fecha de Vencimiento</th><th>Moneda</th><th>Tipo de Cambio</th><th>Afecto IGV</th><th>Porcentaje IGV</th><th>IGV</th><th>Afecto</th><th>Inafecto</th><th>Exonerado</th><th>Total</th><th>Acciones</th></tr>';
        foreach ($documentos as $documento) {
            echo '<tr>';
            echo '<td>' . $documento['nserie'] . '</td>';
            echo '<td>' . $documento['ndocumento'] . '</td>';
            echo '<td>' . $documento['fecha_emision'] . '</td>';
            echo '<td>' . $documento['fecha_vencimiento'] . '</td>';
            echo '<td>' . $documento['moneda'] . '</td>';
            echo '<td>' . $documento['tipo_cambio'] . '</td>';
            echo '<td>' . $documento['afecto_igv'] . '</td>';
            echo '<td>' . $documento['porcentaje_igv'] . '</td>';
            echo '<td>' . $documento['igv'] . '</td>';
            echo '<td>' . $documento['afecto'] . '</td>';
            echo '<td>' . $documento['inafecto'] . '</td>';
            echo '<td>' . $documento['exonerado'] . '</td>';
            echo '<td>' . $documento['total'] . '</td>';
            echo '<td><a href="descargar_pdf.php?documento_id=' . $documento['id'] . '"><img src="pdf_icon.png" alt="Descargar PDF"></a> <a href="descargar_xml.php?documento_id=' . $documento['id'] . '"><img src="xml_icon.png" alt="Descargar XML"></a></td>';
            echo '</tr>';
        }
        echo '</table>';
    } else {
        echo "No se encontraron documentos para el RUC proporcionado.";
    }

    // Cerrar la conexión
    $conn = null;
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
