<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

include_once 'conexion.php';

$bodyRequest = file_get_contents("php://input");

// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$datos = json_decode($bodyRequest, true);

$ruc_cliente = $datos['documento_identidad']; // No es necesario escapar con mysqli_real_escape_string cuando se usan consultas preparadas

// Consulta preparada
$sql = "SELECT e.ruc as empresa, CONCAT(v.nserie, '-', v.ndocumento) AS nrocomprobante, v.fecha_emision as fecha, v.formapago_id as estado, v.total, v.empresa_id, v.docfiscal_id
FROM ventas v
JOIN empresas e ON v.empresa_id = e.id
WHERE v.documento_identidad = ?";

// Preparar la consulta
$stmt = mysqli_prepare($conn, $sql);
if ($stmt) {
    // Vincular parámetros
    mysqli_stmt_bind_param($stmt, "s", $ruc_cliente);
    
    // Ejecutar la consulta
    if (mysqli_stmt_execute($stmt)) {
        // Obtener resultados
        $result = mysqli_stmt_get_result($stmt);
        $rows = mysqli_fetch_all($result, MYSQLI_ASSOC);
        mysqli_free_result($result);
    } else {
        echo "ERROR: Could not able to execute query."; // . mysqli_error($conn);
    }

    // Cerrar la declaración
    mysqli_stmt_close($stmt);
} else {
    echo "ERROR: Could not prepare query."; // . mysqli_error($conn);
}

print_json($rows);
// Cierre de la conexión a la base de datos
mysqli_close($conn);

function print_json($data) {
    header("Content-type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    // header("HTTP/1.1");
    //header("Content-Type: application/json; charset=UTF-8");
    //header("Content-type: application/json; charset=utf-8");
    //echo json_encode($data, JSON_PRETTY_PRINT);
    //echo json_encode($data, JSON_UNESCAPED_UNICODE);
    	
    switch (json_last_error()) {
        case JSON_ERROR_NONE:
          //  echo ' - No errors';
        break;
        case JSON_ERROR_DEPTH:
            echo ' - Maximum stack depth exceeded';
        break;
        case JSON_ERROR_STATE_MISMATCH:
            echo ' - Underflow or the modes mismatch';
        break;
        case JSON_ERROR_CTRL_CHAR:
            echo ' - Unexpected control character found';
        break;
        case JSON_ERROR_SYNTAX:
            echo ' - Syntax error, malformed JSON';
        break;
        case JSON_ERROR_UTF8:
            echo ' - Malformed UTF-8 characters, possibly incorrectly encoded';
        break;
        default:
            echo ' - Unknown error';
        break;
    }
}
?>
