<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la conexion desde cualquier origen
header("Access-Control-Allow-Origin: *");
// Permite la ejecucion de los metodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

// Se incluye el archivo que contiene la clase generica
include_once '../conexion.php';

// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$departamento_id = $datos[0];
$provincia_id = $datos[1];
$ubigeo_pattern = $datos[2] . '%'; // Assuming $datos[2] is the start of the pattern

$sql = "SELECT id, ubigeo FROM ubigeo 
        WHERE departamento_id = ? AND provincia_id = ? AND ubigeo LIKE ? 
        ORDER BY ubigeo";

$rows = array();

if ($stmt = mysqli_prepare($conn, $sql)) {
    // Vincular parámetros a la declaración
    mysqli_stmt_bind_param($stmt, "iis", $departamento_id, $provincia_id, $ubigeo_pattern);

    // Ejecutar la declaración
    mysqli_stmt_execute($stmt);

    // Obtener el resultado
    $result = mysqli_stmt_get_result($stmt);

    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $rows[] = $row;
        }
    } else {
        // Si no se encuentran registros, devolver un array vacío
        print_json([]);
    }

    // Liberar el resultado
    mysqli_free_result($result);
    // Cerrar la declaración
    mysqli_stmt_close($stmt);
} else {
    echo "ERROR: Could not prepare the query.";
}

// Cerrar la conexión a la base de datos
mysqli_close($conn);

// Devolver los resultados como JSON
print_json($rows);

function print_json($data) {
    header("Content-type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    	
    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            //  echo ' - No errors';
            break;
        case JSON_ERROR_DEPTH:
            echo ' - Maximum stack depth exceeded';
            break;
        case JSON_ERROR_STATE_MISMATCH:
            echo ' - Underflow or the modes mismatch';
            break;
        case JSON_ERROR_CTRL_CHAR:
            echo ' - Unexpected control character found';
            break;
        case JSON_ERROR_SYNTAX:
            echo ' - Syntax error, malformed JSON';
            break;
        case JSON_ERROR_UTF8:
            echo ' - Malformed UTF-8 characters, possibly incorrectly encoded';
            break;
        default:
            echo ' - Unknown error';
            break;
	}
}

?>
