<?php
include_once '../conexion.php';

// Obtener los datos combinados del cuerpo de la solicitud
$data = json_decode(file_get_contents("php://input"), true);

// Iniciar la transacción
mysqli_autocommit($conn, false);
// Variable para verificar el estado de la transacción
$transaccionExitosa = true;
$errorMensaje = "";

try {
     // Acceder a los valores individuales de los datos combinados
     $cEmpresa_Id = $data['Empresa_id'];
     $cDocFiscal_id = $data['DocFiscal_Id'];
     $cNSerie = $data['NSerie'];
     $cNDocumento = $data['NDocumento'];
     $cFechaEmision = $data['Fecha_Emision'];
     $cFechaTraslado = $data['Fecha_Traslado'];
     $cFechaVencimiento = $data['Fecha_Vcto'];
     $cNombre = $data['Razon_Social'];
     $cDireccion = $data['Direccion'];
     $cTipDocIdent = $data['Tipo_Documento'];
     $cDocIdentidad = $data['DocIdentidad'];
     $cNDias = $data['NDias'];
     $cMoneda = $data['Moneda'];
     $cTipoCambio = $data['Tipo_Cambio'];
     $cAfectoIgv = $data['Afecto_IGV'];
     $cP_Igv = $data['pIGV'];
     $cIgv = $data['IGV'];
     $cAfectDscto = $data['Descuento'];
     $cP_Dscto = $data['pDSCTO'];
     $cDescuento = $data['Descuento'];
     $cAfectoPercepcion = $data['Afecto_Percepcion'];
     $cP_Percepcion = $data['pPercepcion'];
     $cPercepcion = $data['Percepcion'];
     $cAfecto = $data['Valor_Compra'];
     $cInafecto = $data['Inafecto'];
     $cExonerado = $data['Exonerada'];
     $cTotal = $data['Total_Pagar'];
     $cGuiaRemision = $data['NGuiaRemision'];
     $cCancelado = $data['Cancelado'];
     $cIcbp = $data['ICBPER'];
     $cGratuitas = $data['Gratuitas'];
     $cAfectaKardex = $data['Afecta_Kardex'];
     $cAfectaCaja = $data['Afecta_Caja'];
     $cPeriodo = $data['Periodo'];
     $cMes = $data['Mes'];
     $cFormaPago_Id = $data['Forma_Pago'];
     $cCaja_Id = $data['Caja_Id'];
     $cProveedor_Id = $data['Proveedor_Id'];
     $cSucursal_Id = $data['Sucursal_Id'];
     $cAlmacen_Id = $data['Almacen_Id'];
     $cObservacion = $data['Observacion'];
     //$cServicio = $data['Servicio'];
     $cMotivoNota = $data['MotivoNota'];
     $cDocFiscal_Ref = $data['DocFiscal_Ref'];
     $cNSerie_Ref = $data['NSerie_Ref'];
     $cNDocumento_Ref = $data['Documento_Ref'];
     $cFechaEmision_Ref = $data['Fecha_EmisionRef'];
     $cId_CmpRef = $data['Id_CmpRef'];
     $iIdCmp = $data['IdCmp_M'];
     $cEstado = $data['Estado'];

     $cOperacion = ($cDocFiscal_id == 5) ? 'NCC' : 'NDC';
	 $cTipOperac = ($cDocFiscal_id == 5) ? 'E' : 'I';
          
    if ($cEstado == 'NUEVO') {

        // Ejemplo de inserción en la tabla productos
        $queryCabecera = "INSERT INTO compras(empresa_id, docfiscal_id, nserie, ndocumento, fecha_emision, fecha_traslado, fecha_vencimiento, 
        razon_social, direccion, tipo_docidentidad, documento_identidad, nro_dias, moneda, tipo_cambio, afecto_igv, 
        porcentaje_igv, igv, afecto_dscto, porcentaje_dscto, descuento, afecto_percepcion, porcentaje_percepcion, percepcion,
        afecto, inafecto, exonerado, total, guia_remision, cancelado, icbp, gratuitas, afecta_kardex, afecta_caja, periodo, mes, 
        formapago_id, caja_id, proveedor_id, sucursal_id, almacen_id, observacion, motivo_nota_id, 
        docfis_id_referencial, nserie_referencial, ndocumento_referencial, fecha_referencial)
        VALUES ('$cEmpresa_Id', '$cDocFiscal_id', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cFechaVencimiento', 
        '$cNombre', '$cDireccion', '$cTipDocIdent', '$cDocIdentidad', '$cNDias', '$cMoneda', '$cTipoCambio', '$cAfectoIgv', '$cP_Igv', '$cIgv', 
        '$cAfectDscto', '$cP_Dscto', '$cDescuento', '$cAfectoPercepcion', '$cP_Percepcion', '$cPercepcion', '$cAfecto', '$cInafecto',
        '$cExonerado', '$cTotal', '$cGuiaRemision', '$cCancelado', '$cIcbp', '$cGratuitas', '$cAfectaKardex', '$cAfectaCaja', '$cPeriodo', '$cMes', 
        '$cFormaPago_Id', '$cCaja_Id', '$cProveedor_Id', '$cSucursal_Id', '$cAlmacen_Id', '$cObservacion', '$cMotivoNota',
        '$cDocFiscal_Ref', '$cNSerie_Ref', '$cNDocumento_Ref', '$cFechaEmision_Ref')";

        $resultadoCabecera = mysqli_query($conn, $queryCabecera);
        if (!$resultadoCabecera) {
            echo "Error de MySQL en Cabecera: " . mysqli_error($conn);
            throw new Exception(mysqli_error($conn));
        }
        
        // Obtener el ID del último registro insertado en la cabecera de compras
        $idcompra = mysqli_insert_id($conn);

        // REGISTRO DE COMPRAS
        if ($cDocFiscal_id == 5) {
            $queryReg_Compras = "INSERT INTO registro_compras(nserie, ndocumento, fecha_emision, fecha_vencimiento, tipo_docidentidad, documento_identidad,
                razon_social, afecto, exonerado, inafecto, igv, total, periodo, mes, moneda, tipo_cambio, docfiscal_id, 
                docfis_id_referencial, nserie_referencial, ndocumento_referencial, fecha_referencial, compra_id, empresa_id, sucursal_id)
                VALUES ('$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaVencimiento', '$cTipDocIdent', '$cDocIdentidad', '$cNombre',
                '$cAfecto'*-1, '$cExonerado'*-1, '$cInafecto'*-1, '$cIgv'*-1, '$cTotal'*-1, '$cPeriodo', '$cMes', '$cMoneda', '$cTipoCambio', '$cDocFiscal_id',
                '$cDocFiscal_Ref', '$cNSerie_Ref', '$cNDocumento_Ref', '$cFechaEmision_Ref', '$idcompra', '$cEmpresa_Id', '$cSucursal_Id')";
        } else {
            $queryReg_Compras = "INSERT INTO registro_compras(nserie, ndocumento, fecha_emision, fecha_vencimiento, tipo_docidentidad, documento_identidad,
                razon_social, afecto, exonerado, inafecto, igv, total, periodo, mes, moneda, tipo_cambio, docfiscal_id, 
                docfis_id_referencial, nserie_referencial, ndocumento_referencial, fecha_referencial, compra_id, empresa_id, sucursal_id)
                VALUES ('$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaVencimiento', '$cTipDocIdent', '$cDocIdentidad', '$cNombre',
                '$cAfecto', '$cExonerado', '$cInafecto', '$cIgv', '$cTotal', '$cPeriodo', '$cMes', '$cMoneda', '$cTipoCambio', '$cDocFiscal_id',
                '$cDocFiscal_Ref', '$cNSerie_Ref', '$cNDocumento_Ref', '$cFechaEmision_Ref', '$idcompra', '$cEmpresa_Id', '$cSucursal_Id')";
        }

        $resultadoReg_Compras = mysqli_query($conn, $queryReg_Compras);
        if (!$resultadoReg_Compras) {
            //echo "Error de MySQL en Registro de Compras: " . mysqli_error($conn);
            throw new Exception(mysqli_error($conn));
        }

        // CAJA
        if ($cAfectaCaja == 1) {
            $queryCaja = "INSERT INTO detcaja(cuenta_id, tipo_movcaja, nrecibo, docfiscal_id, nserie, ndocumento, fecha_operacion,
                fecha_emision, ingreso, partida_id, nombre_partida, moneda, tipo_cambio, movimiento_id, operacion, 
                observacion, compraref_id, offsystem, empresa_id, sucursal_id)
                VALUES('$cCaja_Id', 'I', CONCAT('$cNSerie','-','$cNDocumento'), '$cDocFiscal_id', '$cNSerie', '$cNDocumento', '$cFechaEmision',
                '$cFechaEmision', '$cTotal', '$cProveedor_Id', '$cNombre', '$cMoneda', '$cTipoCambio', '$idcompra', '$cOperacion', '$cObservacion', $cId_CmpRef, '1', '$cEmpresa_Id',
                '$cSucursal_Id')";

            $resultadoCaja = mysqli_query($conn, $queryCaja);
            if (!$resultadoCaja) {
                //echo "Error de MySQL en Caja: " . mysqli_error($conn);
                throw new Exception(mysqli_error($conn));
            }    
        };


        // Ejemplo de inserción en la tabla detalle
        foreach ($data['detalle'] as $detalle_) {
            $cAlmacenId = $detalle_['almacen_id'];
            $cProducto_Id = $detalle_['producto_id'];
            $cBonificdProd = $detalle_['bonificacion'];
            $cCodProd = $detalle_['codigo_producto'];
            $cCantidad = $detalle_['cantidad'];
            $cRecogido = $detalle_['recogido'];
            $cCapacidad_Precio = $detalle_['capacidad_precio'];
            $cDescrip_Precio = $detalle_['descrip_precio'];
            $cPrecio_Bruto = $detalle_['precio_bruto'];
            $cDescuento = $detalle_['descuento'];
            $cPrecio = $detalle_['precio'];
            $cPrecioigv = $detalle_['precioigv'];
            $cIgv = $detalle_['igv'];
            $cPercepcion = $detalle_['percepcion'];
            $cAfecto = $detalle_['afecto'];
            $cInafecto = $detalle_['inafecto'];
            $cExonerado = $detalle_['exonerado'];
            $cSubtotal = $detalle_['subtotal'];
            $cSubtotaligv = $detalle_['subtotaligv'];
            $cCosto = $detalle_['costo'];
            $cPeso = $detalle_['peso'];
            $cPorcentaje_Igv = $detalle_['porcentaje_igv'];
            $cIcbp = $detalle_['icbp'];
            $cDescripcion_Servicio = $detalle_['descripcion_servicio'];
            $cVencimiento = $detalle_['vencimiento'];
            $cLote = $detalle_['lote'];
            $cAbrev_Universal = $detalle_['abrev_universal'];
            $cRazon_Social = $cNombre;
            $cIdDocFis = $cDocFiscal_id;
            $cCategoria_Id = $detalle_['categoria_id'];
            $cMarca_Id = $detalle_['marca_id'];
            $cFlete = $detalle_['flete'];
            $cEstiba = $detalle_['estiba'];
            $cModelo_Id = $detalle_['modelo_id'];
            
            $queryDetalle_ = "INSERT INTO detcompras (compra_id, nserie, ndocumento, fecha_emision, fecha_traslado, almacen_id, producto_id, 
                bonificacion, codigo_producto, cantidad, recogido, capacidad_precio, descrip_precio, precio_bruto, descuento, precio, 
                precioigv, igv, percepcion, afecto, inafecto, exonerado, subtotal, subtotaligv, costo, peso, 
                porcentaje_igv, icbp, descripcion_servicio, vencimiento, lote, abrev_universal, docfiscal_id, categoria_id, marca_id,
                flete, estiba, modelo_id, empresa_id, sucursal_id) 
            VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

            $stmtDetalle_ = mysqli_prepare($conn, $queryDetalle_);
            mysqli_stmt_bind_param($stmtDetalle_, "ssssssssssssssssssssssssssssssssssssssss", $idcompra, $cNSerie, $cNDocumento, $cFechaEmision, $cFechaTraslado, $cAlmacenId, $cProducto_Id, 
                $cBonificdProd, $cCodProd, $cCantidad, $cRecogido, $cCapacidad_Precio, $cDescrip_Precio, $cPrecio_Bruto, $cDescuento, $cPrecio, 
                $cPrecioigv, $cIgv, $cPercepcion, $cAfecto, $cInafecto, $cExonerado, $cSubtotal, $cSubtotaligv, $cCosto, $cPeso, 
                $cPorcentaje_Igv, $cIcbp, $cDescripcion_Servicio, $cVencimiento, $cLote, $cAbrev_Universal, $cIdDocFis, $cCategoria_Id, $cMarca_Id,
                $cFlete, $cEstiba, $cModelo_Id, $cEmpresa_Id, $cSucursal_Id);

            if (mysqli_stmt_execute($stmtDetalle_)) {
                echo "Detalle insertado correctamente.";
            } else {
                echo "Error en Detalle: " . mysqli_stmt_error($stmtDetalle_);
                throw new Exception(mysqli_stmt_error($stmtDetalle_));
            }

            //KARDEX
            if ($cAfectaKardex == 1) {
               $queryKardex = "INSERT INTO kardex(nserie, ndocumento, fecha_emision, fecha_traslado, operacion, producto_id, codigo_producto, entrada, costo, 
                salida, precio_venta, recogido, vencimiento, lote, transito, razon_social, observacion, unidad_medida, empresa_id, sucursal_id, 
                almacen_id, compra_id, venta_id, capacidad_Precio, docfiscal_id, categoria_id, marca_id, modelo_id)
               VALUES('$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cOperacion', '$cProducto_Id', '$cCodProd', 0,
               '$cCosto', ('$cCantidad'*'$cCapacidad_Precio'), '$cPrecioigv', ('$cRecogido'*'$cCapacidad_Precio')*-1, '$cVencimiento', '$cLote', 0, '$cNombre', '$cObservacion', 
                '$cDescrip_Precio', '$cEmpresa_Id', '$cSucursal_Id', '$cAlmacenId', '$idcompra', 0,  '$cCapacidad_Precio', '$cIdDocFis', '$cCategoria_Id', '$cMarca_Id',
                '$cModelo_Id')";
                $resultadoKardex = mysqli_query($conn, $queryKardex);
                
                //echo "Consulta SQL Kardex: " . $queryKardex; // Agrega esta línea para depurar

                if (!$resultadoKardex) {
                    echo "Error de MySQL en Kardex: " . mysqli_error($conn);
                   throw new Exception(mysqli_error($conn));
                }
	         
	        }; 
        }

    } elseif ($cEstado == 'MODIFICAR') { 
        $queryUpd_DetCmps = "UPDATE detcompras SET IUD = 'D' WHERE compra_id = $iIdCmp";
        $resultadoUpd_DetCmps = mysqli_query($conn, $queryUpd_DetCmps);        
        if (!$resultadoUpd_DetCmps) {
            throw new Exception(mysqli_error($conn));
        }
        
        $queryUpd_Kardex = "UPDATE kardex SET IUD = 'D' WHERE compra_id = $iIdCmp";
        $resultadoUpd_Kardex = mysqli_query($conn, $queryUpd_Kardex);        
        if (!$resultadoUpd_Kardex) {
            throw new Exception(mysqli_error($conn));
        }

        /*$queryUpd_Cuotas = "UPDATE cuotasproveedores SET IUD = 'D' WHERE compra_id = $iIdVta";
        $resultadoUpd_Cuotas = mysqli_query($conn, $queryUpd_Cuotas);        
        if (!$resultadoUpd_Cuotas) {
            throw new Exception(mysqli_error($conn));
        }*/

        $queryUpd_Kardex_Serie = "UPDATE kardex_serieprod SET IUD = 'D' WHERE movimiento_id = $iIdCmp AND operacion = '$cOperacion'";
        $resultadoUpd_Kardex_Serie = mysqli_query($conn, $queryUpd_Kardex_Serie);        
        if (!$resultadoUpd_Kardex_Serie) {
            throw new Exception(mysqli_error($conn));
        }

        $queryUpd_Compras = "UPDATE compras SET docfiscal_id = '$cDocFiscal_id', nserie = '$cNSerie', ndocumento = '$cNDocumento', 
             fecha_emision = '$cFechaEmision', fecha_traslado = '$cFechaTraslado', fecha_vencimiento = '$cFechaVencimiento', razon_social = '$cNombre',
             direccion = '$cDireccion', tipo_docidentidad = '$cTipDocIdent', documento_identidad = '$cDocIdentidad', nro_dias = '$cNDias', 
             moneda = '$cMoneda', tipo_cambio = '$cTipoCambio', afecto_igv = '$cAfectoIgv', porcentaje_igv = '$cP_Igv', igv = '$cIgv', 
             afecto_dscto = '$cAfectDscto', porcentaje_dscto = '$cP_Dscto', descuento = '$cDescuento', afecto_percepcion = '$cAfectoPercepcion', 
             porcentaje_percepcion = '$cP_Percepcion', percepcion = $cPercepcion, afecto = '$cAfecto', inafecto = '$cInafecto', exonerado = '$cExonerado',
             total = '$cTotal', guia_remision = '$cGuiaRemision', cancelado = '$cCancelado', icbp = '$cIcbp', gratuitas = '$cGratuitas', 
             afecta_kardex = '$cAfectaKardex', afecta_caja = '$cAfectaCaja', periodo = '$cPeriodo', mes = '$cMes', formapago_id = '$cFormaPago_Id',
             caja_id = '$cCaja_Id', proveedor_id = '$cProveedor_Id', almacen_id = $cAlmacen_Id, observacion = '$cObservacion',
             motivo_nota_id = '$cMotivoNota', docfis_id_referencial = '$cDocFiscal_Ref', nserie_referencial = '$cNSerie_Ref', 
             ndocumento_referencial = '$cNDocumento_Ref', fecha_referencial = '$cFechaEmision_Ref' WHERE id = $iIdCmp";
        
        $resultadoUpd_Compras = mysqli_query($conn, $queryUpd_Compras);        
        if (!$resultadoUpd_Compras) {
            throw new Exception(mysqli_error($conn));
        }
           
        // REGISTRO DE COMPRAS
        if ($cDocFiscal_id == 5) {
           $queryUpd_RegCmps = "UPDATE registro_compras SET nserie = '$cNSerie', ndocumento = '$cNDocumento', fecha_emision = '$cFechaEmision', 
               fecha_vencimiento = '$cFechaVencimiento', tipo_docidentidad = '$cTipDocIdent', documento_identidad = '$cDocIdentidad',
               razon_social = '$cNombre', afecto = '$cAfecto'*-1, exonerado = '$cExonerado'*-1, inafecto = '$cInafecto'*-1, igv = '$cIgv'*-1, total = '$cTotal'*-1, 
               periodo = '$cPeriodo', mes = '$cMes', moneda = '$cMoneda', tipo_cambio = '$cTipoCambio', docfiscal_id = '$cDocFiscal_id',
               docfis_id_referencial = '$cDocFiscal_Ref', nserie_referencial = '$cNSerie_Ref', ndocumento_referencial = '$cNDocumento_Ref', 
               fecha_referencial = '$cFechaEmision_Ref' WHERE compra_id = $iIdCmp";
        } else {        
            $queryUpd_RegCmps = "UPDATE registro_compras SET nserie = '$cNSerie', ndocumento = '$cNDocumento', fecha_emision = '$cFechaEmision', 
               fecha_vencimiento = '$cFechaVencimiento', tipo_docidentidad = '$cTipDocIdent', documento_identidad = '$cDocIdentidad',
               razon_social = '$cNombre', afecto = '$cAfecto', exonerado = '$cExonerado', inafecto = '$cInafecto', igv = '$cIgv', total = '$cTotal', 
               periodo = '$cPeriodo', mes = '$cMes', moneda = '$cMoneda', tipo_cambio = '$cTipoCambio', docfiscal_id = '$cDocFiscal_id',
               docfis_id_referencial = '$cDocFiscal_Ref', nserie_referencial = '$cNSerie_Ref', ndocumento_referencial = '$cNDocumento_Ref', 
               fecha_referencial = '$cFechaEmision_Ref' WHERE compra_id = $iIdCmp";
        }

        $resultadoUpd_RegCmps = mysqli_query($conn, $queryUpd_RegCmps);        
        if (!$resultadoUpd_RegCmps) {
            throw new Exception(mysqli_error($conn));
        }
           
        // CAJA
        if ($cAfectaCaja == 1) {
           $queryCount = "SELECT COUNT(id) FROM detcaja WHERE movimiento_id = $iIdCmp AND operacion = '$cOperacion'";
           $result = mysqli_query($conn, $queryCount); // Suponiendo que has establecido una conexión a la base de datos ($conexion)
           if (!$result) {
              // Manejo de error si la consulta falla
              die("Error al ejecutar la consulta: " . mysqli_error($conn));
           }
             
           $row = mysqli_fetch_array($result);
           $count = $row[0];
           if ($count == 0) {
               $queryUpd_DetCaja = "INSERT INTO detcaja(cuenta_id, tipo_movcaja, nrecibo, docfiscal_id, nserie, ndocumento, fecha_operacion,
                 fecha_emision, ingreso, partida_id, nombre_partida, moneda, tipo_cambio, movimiento_id, operacion, 
                 observacion, compraref_id, offsystem, empresa_id, sucursal_id)
               VALUES('$cCaja_Id', 'I', CONCAT('$cNSerie','-','$cNDocumento'), '$cDocFiscal_id', '$cNSerie', '$cNDocumento', '$cFechaEmision',
                 '$cFechaEmision', '$cTotal', '$cProveedor_Id', '$cNombre', '$cMoneda', '$cTipoCambio', '$iIdCmp', '$cOperacion', '$cObservacion', '$cId_CmpRef', '1', '$cEmpresa_Id',
                 '$cSucursal_Id')";
           } else {
               $queryUpd_DetCaja = "UPDATE detcaja SET cuenta_id = '$cCaja_Id', tipo_movcaja = 'I', nrecibo = CONCAT('$cNSerie','-','$cNDocumento'),
                 fecha_operacion = '$cFechaEmision', docfiscal_id = '$cDocFiscal_id', nserie = '$cNSerie', ndocumento = '$cNDocumento', 
                 fecha_emision = '$cFechaEmision', ingreso = '$cTotal', partida_id = '$cProveedor_Id', nombre_partida = '$cNombre', 
                 moneda = '$cMoneda', tipo_cambio = '$cTipoCambio', observacion = '$cObservacion' WHERE movimiento_id = $iIdCmp AND operacion = '$cOperacion'";
           }
           $resultUpdate = mysqli_query($conn, $queryUpd_DetCaja);
           if (!$resultUpdate) {
               // Manejo de error si la actualización falla
               die("Error al ejecutar la actualización: " . mysqli_error($conn));
           }
             
        };  
           
        // CREDITOS POR PAGAR
        /*if ($cFormaPago_Id == 2) {
            $queryCountCxP = "SELECT COUNT(id) FROM creditos_pagar WHERE compra_id = $iIdCmp";
            $result_CxP = mysqli_query($conn, $queryCountCxP); // Suponiendo que has establecido una conexión a la base de datos ($conexion)
            if (!$result_CxP) {
               // Manejo de error si la consulta falla
               die("Error al ejecutar la consulta: " . mysqli_error($conn));
            }
              
            $row_ = mysqli_fetch_array($result_CxP);
            $count_ = $row_[0];
            if ($count_ == 0) {
                $queryCreditosxPag = "INSERT INTO creditos_pagar(nserie, ndocumento, nro_letra, nro_unico, fecha, fecha_vencimiento, documento_identidad, 
                        razon_social, direccion, deuda_soles, deuda_dolar, moneda, tipo_cambio, proveedor_id, compra_id, sucursal_id, empresa_id)
                    VALUES('$cNSerie', '$cNDocumento', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaVencimiento', '$cDocIdentidad', '$cNombre', '$cDireccion',
                        IF('$cMoneda'='01','$cTotal',0), IF('$cMoneda'='02','$cTotal',0), '$cMoneda', '$cTipoCambio', '$cProveedor_Id', '$iIdCmp', 
                        '$cSucursal_Id','$cEmpresa_Id')"; 
        
                $resultadoCreditosxPag = mysqli_query($conn, $queryCreditosxPag);
                if (!$resultadoCreditosxPag) {
                    throw new Exception(mysqli_error($conn));
                }    
            } else {
                $queryCreditosxPag = "UPDATE creditos_pagar SET nserie = '$cNSerie', ndocumento = '$cNDocumento', nro_letra = '$cNSerie', nro_unico = '$cNDocumento', 
                    fecha = '$cFechaEmision', fecha_vencimiento = '$cFechaVencimiento', razon_social = '$cNombre', 
                    deuda_soles = IF('$cMoneda'='01','$cTotal',0), deuda_dolar = IF('$cMoneda'='02','$cTotal',0), moneda = '$cMoneda', 
                    tipo_cambio = '$cTipoCambio', proveedor_id = '$cProveedor_Id' WHERE compra_id = $iIdCmp";
            }
         };*/

         // Ejemplo de inserción en la tabla detalle
        foreach ($data['detalle'] as $detalle_) {
            $cAlmacenId = $detalle_['almacen_id'];
            $cProducto_Id = $detalle_['producto_id'];
            $cBonificdProd = $detalle_['bonificacion'];
            $cCodProd = $detalle_['codigo_producto'];
            $cCantidad = $detalle_['cantidad'];
            $cRecogido = $detalle_['recogido'];
            $cCapacidad_Precio = $detalle_['capacidad_precio'];
            $cDescrip_Precio = $detalle_['descrip_precio'];
            $cPrecio_Bruto = $detalle_['precio_bruto'];
            $cDescuento = $detalle_['descuento'];
            $cPrecio = $detalle_['precio'];
            $cPrecioigv = $detalle_['precioigv'];
            $cIgv = $detalle_['igv'];
            $cPercepcion = $detalle_['percepcion'];
            $cAfecto = $detalle_['afecto'];
            $cInafecto = $detalle_['inafecto'];
            $cExonerado = $detalle_['exonerado'];
            $cSubtotal = $detalle_['subtotal'];
            $cSubtotaligv = $detalle_['subtotaligv'];
            // $cMargen = $detalle_['Margen'];
            $cCosto = $detalle_['costo'];
            $cPeso = $detalle_['peso'];
            $cPorcentaje_Igv = $detalle_['porcentaje_igv'];
            $cIcbp = $detalle_['icbp'];
            $cDescripcion_Servicio = $detalle_['descripcion_servicio'];
            $cVencimiento = $detalle_['vencimiento'];
            $cLote = $detalle_['lote'];
            $cAbrev_Universal = $detalle_['abrev_universal'];
            $cRazon_Social = $cNombre;
            $cIdDocFis = $cDocFiscal_id;
            $cCategoria_Id = $detalle_['categoria_id'];
            $cMarca_Id = $detalle_['marca_id'];
            $cFlete = $detalle_['flete'];
            $cEstiba = $detalle_['estiba'];
            $cModelo_Id = $detalle_['modelo_id'];

            $queryDetalle = "INSERT INTO detcompras (compra_id, nserie, ndocumento, fecha_emision, fecha_traslado, almacen_id, producto_id, 
                bonificacion, codigo_producto, cantidad, recogido, capacidad_precio, descrip_precio, precio_bruto, descuento, precio, 
                precioigv, igv, percepcion, afecto, inafecto, exonerado, subtotal, subtotaligv, costo, peso, 
                porcentaje_igv, icbp, descripcion_servicio, vencimiento, lote, abrev_universal, docfiscal_id, categoria_id, marca_id,
                flete, estiba, modelo_id, empresa_id, sucursal_id) 
            VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

            $stmtDetalle = mysqli_prepare($conn, $queryDetalle);
            mysqli_stmt_bind_param($stmtDetalle, "ssssssssssssssssssssssssssssssssssssssss", $iIdCmp, $cNSerie, $cNDocumento, $cFechaEmision, $cFechaTraslado, $cAlmacenId, $cProducto_Id, 
                $cBonificdProd, $cCodProd, $cCantidad, $cRecogido, $cCapacidad_Precio, $cDescrip_Precio, $cPrecio_Bruto, $cDescuento, $cPrecio, 
                $cPrecioigv, $cIgv, $cPercepcion, $cAfecto, $cInafecto, $cExonerado, $cSubtotal, $cSubtotaligv, $cCosto, $cPeso, 
                $cPorcentaje_Igv, $cIcbp, $cDescripcion_Servicio, $cVencimiento, $cLote, $cAbrev_Universal, $cIdDocFis, $cCategoria_Id, $cMarca_Id,
                $cFlete, $cEstiba, $cModelo_Id, $cEmpresa_Id, $cSucursal_Id);

            if (mysqli_stmt_execute($stmtDetalle)) {
                echo "Detalle insertado correctamente.";
            } else {
                echo "Error en Detalle: " . mysqli_stmt_error($stmtDetalle);
                throw new Exception(mysqli_stmt_error($stmtDetalle));
            }

            //KARDEX
            if ('$cAfectaKardex' == 1) {
               $queryKardex = "INSERT INTO kardex(nserie, ndocumento, fecha_emision, fecha_traslado, operacion, producto_id, codigo_producto, entrada, costo, 
                salida, precio_venta, recogido, vencimiento, lote, transito, razon_social, observacion, unidad_medida, empresa_id, sucursal_id, 
                almacen_id, compra_id, venta_id, capacidad_Precio, docfiscal_id, categoria_id, marca_id, modelo_id)
               VALUES('$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cOperacion', '$cProducto_Id', '$cCodProd', 0,
                '$cCosto', ('$cCantidad'*'$cCapacidad_Precio'), '$cPrecioigv', ('$cRecogido'*'$cCapacidad_Precio')*-1, '$cVencimiento', '$cLote', 0, '$cNombre', '$cObservacion', 
                '$cDescrip_Precio', '$cEmpresa_Id', '$cSucursal_Id', '$cAlmacenId', '$iIdCmp', 0, '$cCapacidad_Precio', '$cIdDocFis', '$cCategoria_Id', '$cMarca_Id',
                '$cModelo_Id')";
                $resultadoKardex = mysqli_query($conn, $queryKardex);

                if (!$resultadoKardex) {
                   throw new Exception(mysqli_error($conn));
                }
	         
	        }; 
        }

        /*// Ejemplo de inserción en la tabla cuotas
        foreach ($cuotas as $cuota) {
            $cCompra_Id = $idCompra; // Usar el mismo Id_Venta generado
            $cNroCuota = $cuota['Venta_id'];
            $cImporte = $cuota['Numero_cuota']; //
            $cFechaPago = $cuota['Fecha_pago'];
            $cCliente_Id = $cuota['Cliente_id'];
            $cEmpresa_Id = $cuota['Empresa_id'];
            $cSucursal_Id = $cuota['Sucursal_id']; // 

            $queryCuotas = "INSERT INTO cuotasclientes(venta_id, numero_cuota, importe, fecha_pago, cliente_id, empresa_id, sucursal_id)
            VALUES('$cVenta_Id', '$cNroCuota', '$cImporte', '$cFechaPago', '$cCliente_Id', '$cEmpresa_Id', '$cSucursal_Id')"; 
            $resultadoCuotas = mysqli_query($conn, $queryCuotas);   

            if (!$resultadoCuotas) {
                throw new Exception(mysqli_error($conn));
            }
        }*/

        /*// Ejemplo de inserción en la tabla series
        foreach ($series as $serie) {
            $cCompra_Id = $iIdCmp;
            $cSerie = $serie['Serie'];
            $cOperacion = $serie['Operacion'];
            $cIdProducto = $serie['Producto_id'];

            $querySerieProducto = "UPDATE kardex_serieprod SET movimiento_id = '$cCompra_Id', operacion = '$cOperacion', IUD = ''
                    WHERE producto_id = '$cIdProducto' AND serie = '$cSerie'";
            $resultadoSerieProducto = mysqli_query($conn, $querySerieProducto);        

            if (!$resultadoSerieProducto) {
                throw new Exception(mysqli_error($conn));
            }
        }*/
        
        //Elimina Detalle de Compra para Evitar la Duplicidad
        $queryDelVtas = "DELETE FROM detcompras WHERE compra_id = $iIdCmp AND IUD = 'D'";
        $resultadoDelVtas = mysqli_query($conn, $queryDelVtas);        
        if (!$resultadoDelVtas) {
           throw new Exception(mysqli_error($conn));
        }

        //Elimina Kardex para Evitar la Duplicidad
	    $queryDelKardex = "DELETE FROM kardex WHERE compra_id = $iIdCmp AND IUD = 'D'";
        $resultadoDelKardex = mysqli_query($conn, $queryDelKardex);        
        if (!$resultadoDelKardex) {
           throw new Exception(mysqli_error($conn));
        }

    }

    // Confirmar la transacción
    mysqli_commit($conn);
    
} catch (Exception $e) {
    // Revertir la transacción en caso de error
    mysqli_rollback($conn);
  //  $transaccionExitosa = false;
   // $errorMensaje = $e->getMessage();
    
     $errorMensaje = $e->getMessage();
    $stackTrace = $e->getTraceAsString();

    // Imprimir el mensaje de error y la pila de rastreo
    echo "Error: " . $errorMensaje . "<br>";
    echo "Trace: " . $stackTrace;
    
    
    
}

// Cerrar la conexión a la base de datos
mysqli_close($conn);

// Enviar una respuesta al cliente
if ($transaccionExitosa) {
    $response = array("ESTADO" => "00", "MENSAJE" => "Los datos se han guardado correctamente");
} else {
    $response = array("ESTADO" => "11", "MENSAJE" => "Error al guardar la información: " . $errorMensaje);
}
echo json_encode($response);

?>
