<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite solicitudes desde cualquier origen (cuidado con esto en produccin)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$sql = $conn->prepare("CALL IM_SeriexSucursal(?,?,?,?,?,?,?,?,@IdSeriexDoc)");
$sql->bind_param("issiiiis", $datos[0], $datos[1], $datos[2], $datos[3], $datos[4], $datos[5], $datos[6], $datos[7]);
$sql->execute();
$sql->close();

$respuesta = array();

if ($datos[7] == "NUEVO") {
    $result = mysqli_query($conn, "SELECT @IdSeriexDoc as nIdSeriexDoc");
    $mensaje = mysqli_fetch_assoc($result);

    if ($mensaje['nIdSeriexDoc'] > 0) {
        $resultado = array(
            'ESTADO' => "1",
            'ID' => $mensaje['nIdSeriexDoc'],
            'MENSAJE' => "LA INFORMACION GUARDO CORRECTAMENTE"
        );
    } else {
        $resultado = array(
            'ESTADO' => "0",
            'ID' => "0",
            'MENSAJE' => "ERROR AL GUARDAR LA INFORMACI07N: " . mysqli_error($conn)
        );
    }
} else {
    $resultado = array(
        'ESTADO' => "1",
        'ID' => "0",
        'MENSAJE' => "LA INFORMACI07N ACTUALIZ07 CORRECTAMENTE"
    );
}

mysqli_close($conn);

// Devolver la respuesta como un objeto JSON
header("HTTP/1.1 200 OK");
header("Content-Type: application/json; charset=UTF-8");

// Imprimir la respuesta JSON
echo json_encode($resultado);
?>
